include <BOSL2/std.scad>

thickness = 2; //mm

payload_length = 5; //mm
payload_hole_diameter = 4; //mm
payload_hole_offset = [2.5,6]; //mm

strap_width = 24; //mm
strap_attachement_opening = 1.8;
strap_attachement_opening_offset = 0.5;
strap_attachement_thickness = 2;

split_attachement = true;
split_attachement_opening = 2;

rounding_radius = 2.5; //mm
opening_rounding_radius = 0.5;//mm

resolution = 100;

// Hidden
strap_attachement_length=strap_attachement_opening+strap_attachement_thickness*2;
strap_attachement_width = strap_width+2*strap_attachement_thickness;


module payload(){
difference(){
    cuboid([payload_length,strap_attachement_width,thickness],anchor=BOTTOM+LEFT+FRONT);
    translate([payload_hole_offset.x,payload_hole_offset.y,thickness/2]) zcyl(r=payload_hole_diameter/2,h=thickness,$fn=resolution);
}
}

module strap_attachement(flip=false){
difference(){
if (flip){
difference(){
    cuboid([strap_attachement_length,strap_attachement_width,thickness],anchor=BOTTOM+LEFT+FRONT,edges=[RIGHT+FRONT,RIGHT+BACK],rounding=rounding_radius,$fn=resolution);
    translate([strap_attachement_thickness-strap_attachement_opening_offset,strap_attachement_thickness,0]) prismoid(
    size1=[strap_attachement_opening,strap_width], size2=[strap_attachement_opening,strap_width], h=thickness,anchor=BOTTOM+LEFT+FRONT, shift=[--strap_attachement_opening_offset,0],
    rounding=opening_rounding_radius,$fn=resolution
);
    }
} else{
difference(){
    cuboid([strap_attachement_length,strap_attachement_width,thickness],anchor=BOTTOM+LEFT+FRONT,edges=[LEFT+FRONT,LEFT+BACK],rounding=rounding_radius,$fn=resolution);
    translate([strap_attachement_thickness+strap_attachement_opening_offset,strap_attachement_thickness,0]) prismoid(
    size1=[strap_attachement_opening,strap_width], size2=[strap_attachement_opening,strap_width], h=thickness,anchor=BOTTOM+LEFT+FRONT, shift=[-strap_attachement_opening_offset,0],
    rounding=opening_rounding_radius,$fn=resolution
);
    }
}
if (split_attachement){
if (flip){
translate([strap_attachement_length-strap_attachement_thickness-strap_attachement_opening_offset,strap_attachement_width/2-split_attachement_opening/2,0]) cuboid([strap_attachement_thickness+strap_attachement_opening_offset,split_attachement_opening,thickness],anchor=BOTTOM+LEFT+FRONT);
} else{
    translate([0,strap_attachement_width/2-split_attachement_opening/2,0]) cuboid([strap_attachement_thickness+strap_attachement_opening_offset,split_attachement_opening,thickness],anchor=BOTTOM+LEFT+FRONT);
}
}
}
}


module body(){
    strap_attachement(flip=false);
    translate([strap_attachement_length,0,0]) payload();
    translate([strap_attachement_length+payload_length,0,0]) 
    strap_attachement(flip=true);
}

body();